#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled;
	u16_n IRQcounter;
	u8 PRG;
	u8 CHR;
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x6,Mapper.PRG);
	MP->SetPRG_ROM32(0x8,3);
	if (Mapper.Mirror)
		MP->Mirror_H();
	else	MP->Mirror_V();
	MP->SetCHR_ROM8(0,Mapper.CHR);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.PRG;
	MI[x++] = Mapper.CHR;
	MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.PRG		= MI[x++];
	Mapper.CHR		= MI[x++];
	Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		Mapper.IRQcounter.s0 += 114;
		if (Mapper.IRQcounter.s0 >= 24576)
			MP->IRQ();
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	Mapper.CHR = What;
	Sync();
}

static	void	__cdecl	WriteEF (int Bank, int Where, int What)
{
	switch (Where & 0x3)
	{
	case 0:	Mapper.PRG = What & 0x0F;
		Sync();				break;
	case 1:	Mapper.Mirror = What & 0x8;
		Sync();				break;
	case 2:	if (What & 0x02)
			Mapper.IRQenabled = 1;
		else
		{
			Mapper.IRQenabled = 0;
			Mapper.IRQcounter.s0 = 0;
		}				break;
	case 3:					break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	for (x = 0xE; x < 0x10; x++)
		MP->SetWriteHandler(x,WriteEF);

	Mapper.PRG = Mapper.Mirror = 0;
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;

	Sync();
}

CTMapperInfo	MapperInfo_254 =
{
	"Ai Senshi Nicol (Pirate)",
	254,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
