#include	"..\DLL\d_iNES.h"

static	struct
{
	PReadFunc Read6;
	PWriteFunc Write6;
	u8 PRG[4], CHR[4];
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
	{
		MP->SetPRG_ROM8(0x8 | (x << 1),Mapper.PRG[x]);
		MP->SetCHR_ROM2(x << 1,Mapper.CHR[x]);
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 4; i++)	MI[x++] = Mapper.CHR[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	Mapper.PRG[i] = MI[x++];
for (i = 0; i < 4; i++)	Mapper.CHR[i] = MI[x++];
	Sync();
}

static	int	__cdecl	Read6 (int Bank, int Where)
{
	if (Where > 0x7FF)
		return Mapper.Read6(Bank,Where);
	else	return 0;
}

static	void	__cdecl	Write6 (int Bank, int Where, int What)
{
	if (Where > 0x7FF)
	{
		Mapper.Write6(Bank,Where,What);
		return;
	}
	switch (Where & 0x007)
	{
	case 0:	Mapper.PRG[0] = What;	break;
	case 1:	Mapper.PRG[1] = What;	break;
	case 2:	Mapper.PRG[2] = What;	break;
	case 3:	Mapper.PRG[3] = What;	break;
	case 4:	Mapper.CHR[0] = What;	break;
	case 5:	Mapper.CHR[1] = What;	break;
	case 6:	Mapper.CHR[2] = What;	break;
	case 7:	Mapper.CHR[3] = What;	break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	Mapper.Read6 = MP->GetReadHandler(0x6);
	Mapper.Write6 = MP->GetWriteHandler(0x6);
	MP->SetReadHandler(0x6,Read6);
	MP->SetWriteHandler(0x6,Write6);

	Mapper.PRG[0] = 0;	Mapper.PRG[1] = 1;
	Mapper.PRG[2] = 0xFE;	Mapper.PRG[3] = 0xFF;
	for (x = 0; x < 4; x++)
		Mapper.CHR[x] = 0;

	Sync();
}

CTMapperInfo	MapperInfo_246 =
{
	"Mapper 246",
	246,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};