#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd, PRG, CHR, Mirror;
	PWriteFunc Write4;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,(Mapper.PRG << 1) | 0);
	MP->SetPRG_ROM16(0xC,(Mapper.PRG << 1) | 1);
	MP->SetCHR_ROM8(0,Mapper.CHR);
	if (Mapper.Mirror)
		MP->Mirror_V();
	else	MP->Mirror_H();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Cmd;
	MI[x++] = Mapper.PRG;
	MI[x++] = Mapper.CHR;
	MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Cmd	= MI[x++];
	Mapper.PRG	= MI[x++];
	Mapper.CHR	= MI[x++];
	Mapper.Mirror	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	if (Loc < 0x4018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	What &= 0x07;
	switch (Loc & 0x4101)
	{
	case 0x4100:	Mapper.Cmd = What;	break;
	case 0x4101:	switch (Mapper.Cmd)
			{
			case 0:	Mapper.PRG = 0;
				Mapper.CHR = 3;				break;
			case 4:	Mapper.CHR &= 0x3;
				Mapper.CHR |= (What & 0x1) << 2;	break;
			case 5:	Mapper.PRG = What & 0x7;		break;
			case 6:	Mapper.CHR &= 0x4;
				Mapper.CHR |= What & 0x3;		break;
			case 7:	Mapper.Mirror = (What & 1);		break;
			}			break;

	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	for (x = 0x4; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.Cmd = 0;
	Mapper.PRG = 0;
	Mapper.CHR = 3;
	Mapper.Mirror = 0;
	Sync();
}

CTMapperInfo	MapperInfo_243 =
{
	"Sachen '74LS374N'",
	243,
	MS_Partial,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};