#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	if (_74xx.Addr & 0x1E)
	{
		MP->SetPRG_ROM16(0x8,_74xx.Addr & 0x1F);
		MP->SetPRG_ROM16(0xC,_74xx.Addr & 0x1F);
	}
	else	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,_74xx.Addr & 0x1F);
	if (_74xx.Addr & 0x20)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_AL(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_AL(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_229 =
{
	"31-in-1",
	229,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};