#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned CHRbank : 4;
			unsigned         : 1;
			unsigned PRGsize : 1;
			unsigned PRG16   : 1;
			unsigned PRGbank : 4;
			unsigned PRGchip : 2;
			unsigned Mir_HV  : 1;
			unsigned         : 2;
		};
		struct
		{
			unsigned n       :16;
		};
	}	Addr;
	u8 openbus = 0;
	Addr.n = _74xx.Addr;

	if (Addr.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
	
	switch (Addr.PRGchip)
	{
	case 2:	openbus = 1;		break;
	case 3:	Addr.PRGchip = 2;	break;
	}
	if (openbus)
	{
		for (openbus = 0x8; openbus <= 0xF; openbus++)
			MP->SetPRG_OB4(openbus);
	}
	else
	{
		if (Addr.PRGsize)
		{
			MP->SetPRG_ROM16(0x8,(Addr.PRGchip << 5) | (Addr.PRGbank << 1) | (Addr.PRG16));
			MP->SetPRG_ROM16(0xC,(Addr.PRGchip << 5) | (Addr.PRGbank << 1) | (Addr.PRG16));
		}
		else MP->SetPRG_ROM32(0x8,(Addr.PRGchip << 4) | (Addr.PRGbank));
	}
	MP->SetCHR_ROM8(0,(Addr.CHRbank << 2) | (_74xx.Data & 0x3));
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_A(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_A(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_228 =
{
	"Action 52",
	228,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};