#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Byte8000, Byte8001;
}	Mapper;

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned PRGbank : 5;
			unsigned PRGsize : 1;
			unsigned Mir_VH  : 1;
			unsigned PRGhi   : 2;
			unsigned         : 7;
		};
		struct
		{
			unsigned b0      : 8;
			unsigned b1      : 8;
		};
	}	Val;

	Val.b0 = Mapper.Byte8000;
	Val.b1 = Mapper.Byte8001;

	if (Val.Mir_VH)
		MP->Mirror_V();
	else	MP->Mirror_H();
	if (Val.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,((Val.PRGhi) << 5) | (Val.PRGbank));
		MP->SetPRG_ROM16(0xC,((Val.PRGhi) << 5) | (Val.PRGbank));
	}
	else	MP->SetPRG_ROM32(0x8,((Val.PRGhi) << 4) | (Val.PRGbank >> 1));
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Byte8000;
	MI[x++] = Mapper.Byte8001;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Byte8000	= MI[x++];
	Mapper.Byte8001	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	switch (Where & 1)
	{
	case 0:	Mapper.Byte8000 = What;		break;
	case 1:	Mapper.Byte8001 = What;		break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.Byte8000 = Mapper.Byte8001 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_226 =
{
	"76-in-1",
	226,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};