#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned CHRbank : 6;
			unsigned PRG16   : 1;
			unsigned PRGbank : 5;
			unsigned PRGsize : 1;
			unsigned Mir_HV  : 1;
			unsigned         : 2;
		};
		struct
		{
			unsigned n       :16;
		};
	}	Addr;
	Addr.n = _74xx.Addr;

	MP->SetCHR_ROM8(0,Addr.CHRbank);
	if (Addr.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,(Addr.PRGbank << 1) | (Addr.PRG16));
		MP->SetPRG_ROM16(0xC,(Addr.PRGbank << 1) | (Addr.PRG16));
	}
	else	MP->SetPRG_ROM32(0x8,Addr.PRGbank);
	if (Addr.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_A(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_A(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_225 =
{
	"72-in-1",
	225,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};