#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	struct
{
	u8 Latch;
	PWriteFunc Write4;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,Mapper.Latch);
	MMC3_SyncCHR_ROM(0x3F,0);
	MMC3_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = MMC3_SaveMI(MI,x);
	MI[x++] = Mapper.Latch;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = MMC3_LoadMI(MI,x);
	Mapper.Latch	= MI[x++];
	Sync();
}

static	void	__cdecl	Write4 (int Bank, int Where, int What)
{
	if (Where == 0x120)
	{
		Mapper.Latch = What >> 4;
		Sync();
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write4);

	MP->SetPRG_RAM8(0x6,0);
	Mapper.Latch = 0;

	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_189 =
{
	"Mapper 189 (Thunder Warrior)",
	189,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};