#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	struct
{
	u8 Latch;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM4(0,((Mapper.Latch & 0x02) << 0) | ((Mapper.Latch & 0x04) >> 2) | ((Mapper.Latch & 0x01) << 2));
	MP->SetCHR_ROM4(4,((Mapper.Latch & 0x20) >> 4) | ((Mapper.Latch & 0x10) >> 1));

//	BANK_CHR4(0x0000, (value & 0x02) + ((value & 0x04)>>2)); /* use bank 1, 3 */
//	BANK_CHR4(0x1000, (value & 0x20) >> 4); /* use bank 0, 2 */

}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Latch;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Latch	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	Mapper.Latch = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x6,Write);
	MP->SetWriteHandler(0x7,Write);

	Mapper.Latch = 0;

	Sync();
}

CTMapperInfo	MapperInfo_184 =
{
	"Mapper 184",
	184,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};