#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,_74xx.Data & 0x7);
	if (MP->CHR_ROM_Size)
		MP->SetCHR_ROM8(0,0);
	else	MP->SetCHR_RAM8(0,0);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_D(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_D(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_180 =
{
	"Mapper 180",
	180,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};