#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Data;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,(Mapper.Data >> 0) & 0xF);
	MP->SetCHR_ROM8 (0,(Mapper.Data >> 4) & 0xF);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Data;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Data = MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	if (Where < 0xF00)
		return;
	Mapper.Data = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	MP->SetWriteHandler(0xF,Write);
	Sync();
}

CTMapperInfo	MapperInfo_144 =
{
	"AGCI",
	144,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
