#include	"..\DLL\d_iNES.h"

static	struct
{
	PReadFunc Read4;
}	Mapper;

static	int	__cdecl	Read (int Bank, int Where)
{
	if (Where & 0x100)
		return (~Where & 0x3F);
	else	return Mapper.Read4(Bank,Where);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	Mapper.Read4 = MP->GetReadHandler(0x4);
	MP->SetReadHandler(0x4,Read);

	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,0);
}

CTMapperInfo	MapperInfo_143 =
{
	"Sachen Pathetic Copy-Protection",
	143,
	MS_Partial,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};