#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Latch;
}	Mapper;

static	void	Sync (void)
{
	MP->SetCHR_ROM8 (  0,(Mapper.Latch >> 0) & 0xF);
	MP->SetPRG_ROM32(0x8,(Mapper.Latch >> 4) & 0xF);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Latch;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Latch	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	Mapper.Latch = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x6,Write);
	MP->SetWriteHandler(0x7,Write);

	Mapper.Latch = 0;

	Sync();
}

CTMapperInfo	MapperInfo_140 =
{
	"Mapper 140 (Bio Senshi Dan)",
	140,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};