#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\Sound\s_VRC7.h"

static	struct
{
	u8 IRQenabled, IRQtoggle, IRQlatch, IRQcounter;
	u8 PRG[3], CHR[8], Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	if (MP->CHR_ROM_Size)
		for (x = 0; x < 8; x++)
			MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	else	for (x = 0; x < 8; x++)
			MP->SetCHR_RAM1(x,Mapper.CHR[x] & 7);
	switch (Mapper.Mirror & 0x3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.IRQtoggle;
			MI[x++] = Mapper.IRQlatch;
			MI[x++] = Mapper.IRQcounter;
for (i = 0; i < 3; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
	x = VRC7sound_SaveMI(MI,x);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQenabled		= MI[x++];
			Mapper.IRQtoggle		= MI[x++];
			Mapper.IRQlatch			= MI[x++];
			Mapper.IRQcounter		= MI[x++];
for (i = 0; i < 3; i++)	Mapper.PRG[i]			= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]			= MI[x++];
			Mapper.Mirror			= MI[x++];
	x = VRC7sound_LoadMI(MI,x);
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter == 0xFF)
		{
			Mapper.IRQcounter = Mapper.IRQlatch;
			MP->IRQ();
		}
		else	Mapper.IRQcounter++;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	if (Where & 0x18)
		Mapper.PRG[1] = What;
	else	Mapper.PRG[0] = What;
	Sync();
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	if (Where & 0x18)
		VRC7sound_Write((Bank << 12) | Where,What);
	else
	{
		Mapper.PRG[2] = What;
		Sync();
	}
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	if (Where & 0x18)
		Mapper.CHR[1] = What;
	else	Mapper.CHR[0] = What;
	Sync();
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	if (Where & 0x18)
		Mapper.CHR[3] = What;
	else	Mapper.CHR[2] = What;
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	if (Where & 0x18)
		Mapper.CHR[5] = What;
	else	Mapper.CHR[4] = What;
	Sync();
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	if (Where & 0x18)
		Mapper.CHR[7] = What;
	else	Mapper.CHR[6] = What;
	Sync();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	if (Where & 0x18)
		Mapper.IRQlatch = What;
	else
	{
		Mapper.Mirror = What;
		Sync();
	}
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	if (Where & 0x18)
		Mapper.IRQenabled = Mapper.IRQtoggle;
	else
	{
		Mapper.IRQtoggle = What & 0x1;
		Mapper.IRQenabled = What & 0x2;
		if (Mapper.IRQenabled)
			Mapper.IRQcounter = Mapper.IRQlatch;
	}
}


static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	VRC7sound_Destroy();
}

static	void	__cdecl	MapperSnd (s16 *Buffer, int Len)
{
	VRC7sound_Get(Buffer,Len);
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	VRC7sound_Init();

	Mapper.IRQenabled = Mapper.IRQtoggle = Mapper.IRQlatch = Mapper.IRQcounter = 0;
	Mapper.PRG[0] = 0x00;	Mapper.PRG[0] = 0x01;	Mapper.PRG[2] = 0xFE;
	for (x = 0; x < 8; x++)	Mapper.CHR[x] = x;
	Sync();
}

CTMapperInfo	MapperInfo_085 =
{
	"Konami VRC7",
	85,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	MapperSnd,
	NULL
};