#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,_74xx.Data & 0x7);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM8(0,(_74xx.Data & 0xF0) >> 4);
	if (_74xx.Data & 0x8)
		((MP->Flags & 0x08) ? MP->Mirror_V : MP->Mirror_S1)();
	else	((MP->Flags & 0x08) ? MP->Mirror_H : MP->Mirror_S0)();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_D(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_D(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_078 =
{
	"Irem 74161/32",
	78,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
