#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_FME07.h"

static	void	Sync (void)
{
	FME07_SyncPRG(0xFF,0);
	FME07_SyncCHR(0xFF,0);
	FME07_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	FME07_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	FME07_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	FME07_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	FME07_Init(Sync);
}

CTMapperInfo	MapperInfo_069 =
{
	"Sunsoft FME-07",
	69,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	FME07_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	FME07_MapperSnd,
	NULL
};