#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned CHRhi   : 5;
			unsigned PRGsize : 1;
			unsigned PRGchip : 1;
			unsigned Mir_HV  : 1;
			unsigned PRG     : 6;
			unsigned         : 2;
			unsigned CHRlo   : 2;
			unsigned         : 6;
		};
		struct
		{
			unsigned addr    :16;
			unsigned data    : 8;
		};
	}	Latch;
	Latch.addr = _74xx.Addr;
	Latch.data = _74xx.Data;

	MP->SetCHR_ROM8(0,(Latch.CHRhi << 2) | Latch.CHRlo);

	if (Latch.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,(Latch.PRGchip << 6) | Latch.PRG);
		MP->SetPRG_ROM16(0xC,(Latch.PRGchip << 6) | Latch.PRG);
	}
	else	MP->SetPRG_ROM32(0x8,((Latch.PRGchip << 6) | Latch.PRG) >> 1);

	if (Latch.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_AD(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_AD(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_062 =
{
	"700-in-1",
	62,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};