#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRGcontrol;
	u8 PRGlow[4], PRGhigh[4];
	u8 CHR[8];
	u8 Mirror;
	u16_n IRQcounter;
	u8 IRQenabled;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x6,Mapper.PRGlow[3] | Mapper.PRGhigh[3]);
	for (x = 0; x < 3; x++)
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRGlow[x] | Mapper.PRGhigh[x]);
	MP->SetPRG_ROM8(0xE,-1);
	if (Mapper.Mirror)
		MP->Mirror_V();
	else	MP->Mirror_H();
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.PRGcontrol;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRGlow[i];
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRGhigh[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
			MI[x++] = Mapper.IRQcounter.b0;
			MI[x++] = Mapper.IRQcounter.b1;
			MI[x++] = Mapper.IRQenabled;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.PRGcontrol	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRGlow[i]	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRGhigh[i]	= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];
			Mapper.IRQcounter.b0	= MI[x++];
			Mapper.IRQcounter.b1	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter.s0 > (0xFFFF - 113))
		{
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter.s0 += 113;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n0 = What & 0xF;
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n1 = What & 0xF;
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n2 = What & 0xF;
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	Mapper.IRQcounter.n3 = What & 0xF;
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	Mapper.IRQenabled = What & 0xF;
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	Mapper.PRGcontrol = What & 0xF;
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	switch (Mapper.PRGcontrol)
	{
	case 0x1:	Mapper.PRGlow[0] = What & 0xF;	break;
	case 0x2:	Mapper.PRGlow[1] = What & 0xF;	break;
	case 0x3:	Mapper.PRGlow[2] = What & 0xF;	break;
	case 0x4:	Mapper.PRGlow[3] = What & 0xF;	break;
	}
	switch (Where & 0xC00)
	{
	case 0x000:	Mapper.PRGhigh[Where & 0x03] = What & 0x10;	break;
	case 0x800:	Mapper.Mirror = What & 0x01;			break;
	case 0xC00:	Mapper.CHR[Where & 0x07] = What;		break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	for (x = 0; x < 4; x++)
		Mapper.PRGlow[x] = Mapper.PRGhigh[x] = Mapper.CHR[x | 0] = Mapper.CHR[x | 4] = 0;
	Mapper.PRGcontrol = Mapper.Mirror = 0;

	Sync();
}

CTMapperInfo	MapperInfo_056 =
{
	"SMB3 Pirate",
	56,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};