#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Reg0, Reg1;
}	Mapper;

static	void	Sync (void)
{
	if (Mapper.Reg0 & 0x20)
		MP->Mirror_H();
	else	MP->Mirror_V();
	MP->SetPRG_ROM32(0x8,Mapper.Reg0 & 0x7);
	MP->SetCHR_ROM8(0,Mapper.Reg1 | ((Mapper.Reg0 >> 1) & 0xC));
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Reg0;
	MI[x++] = Mapper.Reg1;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Reg0	= MI[x++];
	Mapper.Reg1	= MI[x++];
	Sync();
}

static	void	__cdecl	WriteLo (int Bank, int Where, int What)
{
	if (Where & 0x800)
		return;
	Mapper.Reg0 = Where & 0x3F;
	Sync();
}

static	void	__cdecl	WriteHi (int Bank, int Where, int What)
{
	if (Mapper.Reg0 & 0x4)
	{
		Mapper.Reg1 = What & 0x03;
		Sync();
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x6,WriteLo);
	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,WriteHi);

	Mapper.Reg0 = Mapper.Reg1 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_041 =
{
	"Caltron 6-in-1",
	41,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};