#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Byte9xxx;
	u8 PRG[3];
	u8 CHR[8];
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	if (Mapper.Byte9xxx & 0x01)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.Byte9xxx;
for (i = 0; i < 3; i++) MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.Byte9xxx		= MI[x++];
for (i = 0; i < 3; i++) Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
	Sync();
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	if (Mapper.Byte9xxx & 2)
		Mapper.PRG[2] = What;
	else	Mapper.PRG[0] = What;
	Sync();
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	Mapper.Byte9xxx = What;
	Sync();
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	Mapper.PRG[1] = What;
	Sync();
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	Mapper.CHR[Where & 7] = What;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);

	Mapper.PRG[0] = 0;	Mapper.PRG[1] = 1;	Mapper.PRG[2] = -1;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = 0;
	Mapper.Byte9xxx = 0;
	Sync();
}

CTMapperInfo	MapperInfo_032 =
{
	"Irem G-101",
	32,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
