#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\Sound\s_VRC6.h"

static	struct
{
	u8 IRQenabled, IRQcounter, IRQlatch;
	u8 SwapAddr[4];
	u8 PRG[2], CHR[8];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM16(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xE,-1);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	switch ((Mapper.Mirror >> 2) & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.IRQlatch;
			MI[x++] = Mapper.IRQenabled;
for (i = 0; i < 2; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
	x = VRC6sound_SaveMI(MI,x);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter	= MI[x++];
			Mapper.IRQlatch		= MI[x++];
			Mapper.IRQenabled	= MI[x++];
for (i = 0; i < 2; i++)	Mapper.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];
	x = VRC6sound_LoadMI(MI,x);
	Sync();
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	if ((Mapper.IRQenabled & 2) && (Mapper.IRQcounter))
	{
		if (Mapper.IRQcounter == 0xFF)
		{
			Mapper.IRQcounter = Mapper.IRQlatch;
			MP->IRQ();
		}
		else	Mapper.IRQcounter++;
	}
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	switch (Mapper.SwapAddr[Where & 3])
	{
	case 0:	Mapper.PRG[0] = What;
		Sync();			break;
	case 1:				break;
	case 2:				break;
	case 3:				break;
	}
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	VRC6sound_Write(0x9000 | Mapper.SwapAddr[Where & 3],What);
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	VRC6sound_Write(0xA000 | Mapper.SwapAddr[Where & 3],What);
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	switch (Mapper.SwapAddr[Where & 3])
	{
	case 0:	case 1:	case 2:
		VRC6sound_Write(0xB000 | Mapper.SwapAddr[Where & 3],What);
					break;
	case 3:	Mapper.Mirror = What;
		Sync();			break;
	}
	
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	switch (Mapper.SwapAddr[Where & 3])
	{
	case 0:	Mapper.PRG[1] = What;
		Sync();			break;
	case 1:				break;
	case 2:				break;
	case 3:				break;
	}
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	Mapper.CHR[Mapper.SwapAddr[Where & 3]] = What;
	Sync();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	Mapper.CHR[4 | Mapper.SwapAddr[Where & 3]] = What;
	Sync();
}

static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	switch (Mapper.SwapAddr[Where & 3])
	{
	case 0:	Mapper.IRQlatch = What;	break;
	case 1:	Mapper.IRQenabled = What & 3;
		if (Mapper.IRQenabled & 2)
			Mapper.IRQcounter = Mapper.IRQlatch;
					break;
	case 2:	if (Mapper.IRQenabled & 1)
			Mapper.IRQenabled |= 2;
		else	Mapper.IRQenabled &= 1;
					break;
	case 3:				break;
	}
}

static	void	__cdecl	MapperSnd (s16 *Buffer, int Len)
{
	VRC6sound_Get(Buffer,Len);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	VRC6sound_Destroy();
}

static	void	VRC6_InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	Mapper.PRG[0] = 0;
	Mapper.PRG[1] = -2;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = x;
	Mapper.IRQenabled = Mapper.IRQcounter = Mapper.IRQlatch = 0;

	VRC6sound_Init();
	Sync();
}

static	void	__cdecl	InitMapper_024 (const PMapperParam _MP, int IsHardReset)
{
	VRC6_InitMapper(_MP,IsHardReset);
	Mapper.SwapAddr[0] = 0;
	Mapper.SwapAddr[1] = 1;
	Mapper.SwapAddr[2] = 2;
	Mapper.SwapAddr[3] = 3;
}

static	void	__cdecl	InitMapper_026 (const PMapperParam _MP, int IsHardReset)
{
	VRC6_InitMapper(_MP,IsHardReset);
	Mapper.SwapAddr[0] = 0;
	Mapper.SwapAddr[1] = 2;
	Mapper.SwapAddr[2] = 1;
	Mapper.SwapAddr[3] = 3;
}

CTMapperInfo	MapperInfo_024 =
{
	"Konami VRC6 A0/A1",
	24,
	MS_Full,
	8192,
	InitMapper_024,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	MapperSnd,
	NULL
};

CTMapperInfo	MapperInfo_026 =
{
	"Konami VRC6 A1/A0",
	26,
	MS_Full,
	8192,
	InitMapper_026,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	MapperSnd,
	NULL
};
