#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[2];
	u8 CHR[8];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM16(0xC,-1);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	switch (Mapper.Mirror & 3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S1();	break;
	case 3:	MP->Mirror_S0();	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 2; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 2; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]	= MI[x++];
			Mapper.Mirror	= MI[x++];
	Sync();
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	Mapper.PRG[0] = What;
	Sync();
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	Mapper.Mirror = What;
	Sync();
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	Mapper.PRG[1] = What;
	Sync();
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	Mapper.CHR[0 | (Where & 1)] = What >> 1;
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	Mapper.CHR[2 | (Where & 1)] = What >> 1;
	Sync();
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	Mapper.CHR[4 | (Where & 1)] = What >> 1;
	Sync();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	Mapper.CHR[6 | (Where & 1)] = What >> 1;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	iNES_InitROM();

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);

	Mapper.PRG[0] = 0;	Mapper.PRG[1] = 1;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = x;
	Mapper.Mirror = 0;
	Sync();
}

CTMapperInfo	MapperInfo_022 =
{
	"Konami VRC2 Type A",
	22,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};