#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC4.h"

static	void	Sync (void)
{
	MMC4_SyncPRG(0xFF,0);
	MMC4_SyncCHR();
	MMC4_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC4_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC4_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC4_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	MMC4_Init(Sync);
}

CTMapperInfo	MapperInfo_010 =
{
	"Nintendo MMC4",
	10,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	MMC4_TileHandler,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};