#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC2.h"

static	void	Sync (void)
{
	MMC2_SyncPRG(0xF,0);
	MMC2_SyncCHR();
	MMC2_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC2_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC2_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC2_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	MMC2_Init(Sync);
}

CTMapperInfo	MapperInfo_009 =
{
	"PNROM (MMC2)",
	9,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	MMC2_TileHandler,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};