#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	void	Sync (void)
{
	if (MP->Flags & 0x08)
		MP->Mirror_4();
	else	MMC3_SyncMirror();
	MMC3_SyncPRG(0x3F,0);

	if (MP->CHR_ROM_Size)
		MMC3_SyncCHR_ROM(0xFF,0);
	else	MMC3_SyncCHR_RAM(0x07,0);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC3_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC3_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();

	MP->SetPRG_RAM8(0x6,0);		/* Map WRAM no matter what */

	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_004 =
{
	"T*ROM/HKROM (MMC3/MMC6)",
	4,
	MS_Nearly,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
