#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_VS.h"

static	CPMapperInfo	CurrentMapper;

static	void	__cdecl	InitMapper_GENERIC (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	VS_Init(IsHardReset);
	if (CurrentMapper->InitMapper)
		CurrentMapper->InitMapper(_MP,IsHardReset);
}
static	void	__cdecl	UnloadMapper_GENERIC (void)
{
	if (CurrentMapper->UnloadMapper)
		CurrentMapper->UnloadMapper();
}
static	void	__cdecl	HBlank_GENERIC (int Scanline, int Byte2001)
{
	VS_CheckCoin(Scanline);
	if (CurrentMapper->HBlank)
		CurrentMapper->HBlank(Scanline,Byte2001);
}
static	int	__cdecl	TileHandler_GENERIC (int Bank, int TileNum, int Index)
{
	u8 x = 0;
	if (CurrentMapper->TileHandler)
		x += CurrentMapper->TileHandler(Bank,TileNum,Index);
	return x;
}
static	void	__cdecl	SaveMI_GENERIC (Ar128 MI)
{
	u8 x = VS_SaveMI(MI);
	if (CurrentMapper->SaveMI)
		CurrentMapper->SaveMI(&MI[x]);
}
static	void	__cdecl	LoadMI_GENERIC (const Ar128 MI)
{
	u8 x = VS_LoadMI(MI);
	if (CurrentMapper->LoadMI)
		CurrentMapper->LoadMI(&MI[x]);
}
static	void	__cdecl	MapperSnd_GENERIC (s16 *Buffer, int Len)
{
	if (CurrentMapper->MapperSnd)
		CurrentMapper->MapperSnd(Buffer,Len);
}
static	void	__cdecl	MenuClick_GENERIC (int Command, int Parm1, int Parm2, int Parm3)
{
	VS_MenuClick(Command,Parm1,Parm2,Parm3);
	if (CurrentMapper->MenuClick)
		CurrentMapper->MenuClick(Command,Parm1,Parm2,Parm3);
}

static	TMapperInfo	GenericMapper =
{
	"Generic Mapper",
	-1,
	MS_None,
	0,
	InitMapper_GENERIC,
	UnloadMapper_GENERIC,
	HBlank_GENERIC,
	TileHandler_GENERIC,
	SaveMI_GENERIC,
	LoadMI_GENERIC,
	MapperSnd_GENERIC,
	MenuClick_GENERIC
};

PMapperInfo	LoadGenericMapper (CPMapperInfo Mapper)
{
	CurrentMapper = Mapper;
	GenericMapper.BoardName = CurrentMapper->BoardName;
	GenericMapper.MapperNum = CurrentMapper->MapperNum;
	GenericMapper.MapperSupport = CurrentMapper->MapperSupport;
	GenericMapper.BankSize = CurrentMapper->BankSize;
	return &GenericMapper;
}