#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC5.h"

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC5_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC5_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	UNIF_SaveSRAM();
	MMC5_Destroy();
}

static	void	__cdecl	InitMapper_EKROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(8192);
	MMC5.WRAMsize = MMC5WRAM_8KB_0KB;
	MMC5_Init();
}

static	void	__cdecl	InitMapper_ELROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MMC5.WRAMsize = MMC5WRAM_0KB_0KB;
	MMC5_Init();
}

static	void	__cdecl	InitMapper_ETROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(8192);
	MMC5.WRAMsize = MMC5WRAM_8KB_8KB;
	MMC5_Init();
}

static	void	__cdecl	InitMapper_EWROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	UNIF_InitSRAM(32768);
	MMC5.WRAMsize = MMC5WRAM_32KB_0KB;
	MMC5_Init();
}

CTMapperInfo	MapperInfo_NES_EKROM =
{
	"NES-EKROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_EKROM,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	SaveMI,
	LoadMI,
	MMC5_MapperSnd,
	NULL
};
CTMapperInfo	MapperInfo_NES_ELROM =
{
	"NES-ELROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_ELROM,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	SaveMI,
	LoadMI,
	MMC5_MapperSnd,
	NULL
};
CTMapperInfo	MapperInfo_NES_ETROM =
{
	"NES-ETROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_ETROM,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	SaveMI,
	LoadMI,
	MMC5_MapperSnd,
	NULL
};
CTMapperInfo	MapperInfo_NES_EWROM =
{
	"NES-EWROM",
	-1,
	MS_Nearly,
	8192,
	InitMapper_EWROM,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	SaveMI,
	LoadMI,
	MMC5_MapperSnd,
	NULL
};