#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync_CNROM (void)
{
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,1);
	MP->SetCHR_ROM8(0,_74xx.Data & 0x03);
}
static	void	Sync_CPROM (void)
{
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,1);
	MP->SetCHR_RAM4(0,0);
	MP->SetCHR_RAM4(4,_74xx.Data & 0x3);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_D(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_D(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper_CNROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_CNROM,IsHardReset,TRUE);
	UNIF_SetMirroring(NULL);
}
static	void	__cdecl	InitMapper_CPROM (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync_CPROM,IsHardReset,TRUE);
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_NES_CNROM =
{
	"NES-CNROM",
	-1,
	MS_Full,
	32768,
	InitMapper_CNROM,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
CTMapperInfo	MapperInfo_NES_CPROM =
{
	"NES-CPROM",
	-1,
	MS_Full,
	32768,
	InitMapper_CPROM,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};