#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	struct
{
	u8 Game;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM8(0x6,((Mapper.Game & 0xF) << 4) | 0xF);
	if (Mapper.Game & 0x10)
	{
		MP->SetPRG_ROM16(0x8,((Mapper.Game & 0xF) << 3) | (_74xx.Data & 0x7));
		MP->SetPRG_ROM16(0xC,((Mapper.Game & 0xF) << 3) | 0x7);
	}
	else	MP->SetPRG_ROM32(0x8,0x40); /* the EPROM at the end */
	MP->SetCHR_RAM8(0,0);
	if (Mapper.Game & 0x20)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	x = _74xx_SaveMI_D(MI,x);
	MI[x++] = Mapper.Game;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	x = _74xx_LoadMI_D(MI,x);
	Mapper.Game = MI[x++];
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	if (Mapper.Game & 0x10)
		return;
	Mapper.Game = What & 0x3F;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);
	Mapper.Game = 0;
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_BMC_Supervision16in1 =
{
	"BMC-Supervision16in1",
	-1,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};