#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetCHR_ROM8(0,_74xx.Addr & 0x07);
	if (_74xx.Addr & 0x40)
	{
		MP->SetPRG_ROM16(0x8,(_74xx.Addr & 0x38) >> 3);
		MP->SetPRG_ROM16(0xC,(_74xx.Addr & 0x38) >> 3);
	}
	else	MP->SetPRG_ROM32(0x8,(_74xx.Addr & 0x30) >> 4);
	if (_74xx.Addr & 0x80)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_AL(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_AL(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_BMC_SV01 =
{
	"BMC-SV01",
	-1,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};