#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,_74xx.Addr & 0x3);
	MP->SetCHR_ROM8(0,_74xx.Addr & 0x7);
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_AL(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_AL(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_BMC_NovelDiamond9999999in1 =
{
	"BMC-NovelDiamond9999999in1",
	-1,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};