#include	"..\..\DLL\d_UNIF.h"

static	struct
{
	u8 Regs[2];
}	Mapper;

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned PRGbank : 5;
			unsigned PRGsize : 1;
			unsigned Mir_VH  : 1;
			unsigned PRGhi   : 2;
			unsigned         : 7;
		};
		struct
		{
			unsigned byte0   : 8;
			unsigned byte1   : 8;
		};
	}	Latch;

	Latch.byte0 = Mapper.Regs[0];
	Latch.byte1 = Mapper.Regs[1];

	if (Latch.Mir_VH)
		MP->Mirror_V();
	else	MP->Mirror_H();
	if (Latch.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,((Latch.PRGhi) << 5) | (Latch.PRGbank));
		MP->SetPRG_ROM16(0xC,((Latch.PRGhi) << 5) | (Latch.PRGbank));
	}
	else	MP->SetPRG_ROM32(0x8,((Latch.PRGhi) << 4) | (Latch.PRGbank >> 1));
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 2; i++)	MI[x++] = Mapper.Regs[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 2; i++)	Mapper.Regs[i]	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	Mapper.Regs[Where & 1] = What;
	Sync();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,Write);
	for (x = 0; x < 2; x++)	Mapper.Regs[x] = 0;
	Sync();
}

CTMapperInfo	MapperInfo_BMC_Generic76in1 =
{
	"BMC-Generic76in1",
	-1,
	MS_Full,
	32768,
	InitMapper,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};