#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned CHRbank : 6;
			unsigned PRG16   : 1;
			unsigned PRGbank : 5;
			unsigned PRGsize : 1;
			unsigned Mir_HV  : 1;
			unsigned         : 2;
		};
		struct
		{
			unsigned addr    :16;
		};
	}	Latch;
	Latch.addr = _74xx.Addr;

	MP->SetCHR_ROM8(0,Latch.CHRbank);
	if (Latch.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,(Latch.PRGbank << 1) | (Latch.PRG16));
		MP->SetPRG_ROM16(0xC,(Latch.PRGbank << 1) | (Latch.PRG16));
	}
	else	MP->SetPRG_ROM32(0x8,Latch.PRGbank);
	if (Latch.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_A(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_A(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_BMC_Generic52in1 =
{
	"BMC-Generic52in1",
	-1,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};