#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	struct
{
	u8 Regs[4];
}	Mapper;

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned CHRbank : 6;
			unsigned PRG16   : 1;
			unsigned PRGbank : 5;
			unsigned PRGsize : 1;
			unsigned Mir_HV  : 1;
			unsigned PRGchip : 1;
			unsigned         : 1;
		};
		struct
		{
			unsigned addr    :16;
		};
	}	Latch;
	Latch.addr = _74xx.Addr;
	MP->SetCHR_ROM8(0,Latch.CHRbank);
	if (Latch.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,(Latch.PRGchip << 6) | (Latch.PRGbank << 1) | (Latch.PRG16));
		MP->SetPRG_ROM16(0xC,(Latch.PRGchip << 6) | (Latch.PRGbank << 1) | (Latch.PRG16));
	}
	else	MP->SetPRG_ROM32(0x8,(Latch.PRGchip << 5) | Latch.PRGbank);
	if (Latch.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			x = _74xx_SaveMI_A(MI,x);
for (i = 0; i < 4; i++)	MI[x++] = Mapper.Regs[i];
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			x = _74xx_LoadMI_A(MI,x);
for (i = 0; i < 4; i++)	Mapper.Regs[i] = MI[x++];
	Sync();
}

static	int	__cdecl	ReadRegs (int Bank, int Where)
{
	if (Where & 0x800)
		return Mapper.Regs[Where & 3];
	else	return 0;
}

static	void	__cdecl	WriteRegs (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.Regs[Where & 3] = What & 0xF;
}

static	void	__cdecl	UnloadMapper (void)
{
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	MP->SetReadHandler(0x5,ReadRegs);
	MP->SetWriteHandler(0x5,WriteRegs);
	_74xx_Init(Sync,IsHardReset,FALSE);
	if (IsHardReset)
	{
		Mapper.Regs[0] = Mapper.Regs[2] = 0xF;
		Mapper.Regs[1] = Mapper.Regs[3] = 0x0;
	}
}

CTMapperInfo	MapperInfo_BMC_Generic115in1 =
{
	"BMC-Generic115in1",
	-1,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};