#include	"..\..\DLL\d_UNIF.h"

static	struct
{
	u8 Game;
        u8 CHR[8];
	u8 PRG[2];
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
                MP->SetCHR_ROM1(x,(Mapper.Game << 5) | Mapper.CHR[x]);
	
	for (x = 0; x < 2; x++)
		MP->SetPRG_ROM16(0x8 | (x << 2),(Mapper.Game << 3) | Mapper.PRG[x]);
}

static	void	__cdecl	Write6 (int Bank, int Where, int What)
{
        switch (Where)
	{
        case 0:	Mapper.CHR[0] = What & 0x3F;	break;
        case 1:	Mapper.CHR[1] = What & 0x3F;	break;
        case 2:	Mapper.CHR[2] = What & 0x3F;	break;
        case 3:	Mapper.CHR[3] = What & 0x3F;	break;
	case 4:	/* mirroring */		break;
	}
	Sync();
}

static	void	__cdecl	Write7 (int Bank, int Where, int What)
{
        switch (Where)
	{
	case 0:	Mapper.PRG[0] = What & 0x7;	break;
	case 1:	Mapper.PRG[1] = What & 0x7;	break;
	}
	Sync();
}

static	void	__cdecl	Write89ABCDEF (int Bank, int Where, int What)
{
	Mapper.Game = What;
	Sync();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	MP->SetWriteHandler(0x6,Write6);
	MP->SetWriteHandler(0x7,Write7);
	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write89ABCDEF);

	Mapper.PRG[0] = 6;	Mapper.PRG[1] = 7;
	Mapper.Game = 0;
	
	Sync();
}

const	TMapperInfo	MapperInfo_BMC_1995SuperHiK4in1 =
{
	"BMC-1995SuperHik4in1",
	-1,
	MS_None,
	8192,
	InitMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};