#ifndef	__FDS_H__
#define	__FDS_H__

#include	"..\interface.h"

typedef	struct	FDS
{
	PReadFunc Read;
	PWriteFunc Write;
	u8 DiskNum;
	u16 IRQcounter;
	u16_n IRQlatch;
	u8 IRQenabled;
	u8 IOenable;
	u8 IOcontrol;
	u8 IOstatus;
	u8 DriveStatus;
	int BytePtr;
	u8 WriteSkip;
	u8 DiskIRQ;
}	TFDS, *PFDS;

extern	TFDS	FDS;

int		FDS_SaveMI	(Ar128,int);
int		FDS_LoadMI	(const Ar128,int);
void		FDS_Init	(void);
void	__cdecl	FDS_HBlank	(int,int);
void	__cdecl	FDS_MenuClick	(int,int,int,int);
void	__cdecl	FDS_MapperSnd	(s16 *,int);
int	__cdecl	FDS_Read	(int,int);
void	__cdecl	FDS_Write	(int,int,int);
void		FDS_Destroy	(void);

#endif	/* __FDS_H__ */