#include	"..\..\interface.h"
#include	"s_VRC6.h"

static	TVRC6sound	VRC6sound;

static	void	VRC6_GenerateSaw (PVRC6saw ChanData, s16 *Target, int Size)
{
	int x;
	for (x = 0; x < Size; x++)
	{
		ChanData->LCtr -= NES_INC_SIZE_INT;
		while (ChanData->LCtr < 0)
		{
			ChanData->CurP += ChanData->volume;
			ChanData->Acc++;
			ChanData->Acc %= 7;
			if (ChanData->Acc == 0)
				ChanData->CurP = 0;
			ChanData->LCtr += (ChanData->freq + 1) << 17;
		}
		Target[x] += ChanData->CurP;
	}
}

static	void	VRC6_GenerateSquare (PVRC6sqr ChanData, s16 *Target, int Size)
{
	int x;
	for (x = 0; x < Size; x++)
	{
		ChanData->LCtr -= NES_INC_SIZE_INT;
		while (ChanData->LCtr < 0)
		{
			ChanData->CurP++;
			ChanData->CurP &= 0xF;
			ChanData->LCtr += (ChanData->freq + 1) << 16;
		}
		Target[x] += ChanData->volume * ((ChanData->CurP <= ChanData->duty) ? 4 : -4);
	}
}

void	VRC6sound_Init (void)
{
	memset(&VRC6sound,0,sizeof(VRC6sound));
}

void	VRC6sound_Write (int Where, int What)
{
	switch (Where)
	{
	case 0x9000:	VRC6sound.Sqr[0].byte0 = What;	break;
	case 0x9001:	VRC6sound.Sqr[0].byte1 = What;	break;
	case 0x9002:	VRC6sound.Sqr[0].byte2 = What;	break;
	case 0xA000:	VRC6sound.Sqr[1].byte0 = What;	break;
	case 0xA001:	VRC6sound.Sqr[1].byte1 = What;	break;
	case 0xA002:	VRC6sound.Sqr[1].byte2 = What;	break;
	case 0xB000:	VRC6sound.Saw.byte0 = What;	break;
	case 0xB001:	VRC6sound.Saw.byte1 = What;	break;
	case 0xB002:	VRC6sound.Saw.byte2 = What;	break;
	}
}

void	VRC6sound_Get (s16 *Target, int Size)
{
	if (VRC6sound.Sqr[0].enabled)	VRC6_GenerateSquare(&VRC6sound.Sqr[0],Target,Size);
	if (VRC6sound.Sqr[1].enabled)	VRC6_GenerateSquare(&VRC6sound.Sqr[1],Target,Size);
	if (VRC6sound.Saw.enabled)	VRC6_GenerateSaw(&VRC6sound.Saw,Target,Size);
}

int	VRC6sound_SaveMI (Ar128 MI, int x)
{
	MI[x++] = VRC6sound.Sqr[0].byte0;
	MI[x++] = VRC6sound.Sqr[0].byte1;
	MI[x++] = VRC6sound.Sqr[0].byte2;
	MI[x++] = VRC6sound.Sqr[1].byte0;
	MI[x++] = VRC6sound.Sqr[1].byte1;
	MI[x++] = VRC6sound.Sqr[1].byte2;
	MI[x++] = VRC6sound.Saw.byte0;
	MI[x++] = VRC6sound.Saw.byte1;
	MI[x++] = VRC6sound.Saw.byte2;
	return x;
}

int	VRC6sound_LoadMI (const Ar128 MI, int x)
{
	VRC6sound.Sqr[0].byte0 = MI[x++];
	VRC6sound.Sqr[0].byte1 = MI[x++];
	VRC6sound.Sqr[0].byte2 = MI[x++];
	VRC6sound.Sqr[1].byte0 = MI[x++];
	VRC6sound.Sqr[1].byte1 = MI[x++];
	VRC6sound.Sqr[1].byte2 = MI[x++];
	VRC6sound.Saw.byte0 = MI[x++];
	VRC6sound.Saw.byte1 = MI[x++];
	VRC6sound.Saw.byte2 = MI[x++];
	return x;
}

void	VRC6sound_Destroy (void)
{
}