#include	"..\..\interface.h"
#include	"s_MMC5.h"

static	TMMC5sound	MMC5sound;

static	struct
{
	const int Duties[4][16];
	const int DLays[32];
}	MMC5sound_data = {
	{	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,-4,-4},	// 87.5%
		{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,-4,-4,-4,-4},	// 75.0%
		{ 4, 4, 4, 4, 4, 4, 4, 4,-4,-4,-4,-4,-4,-4,-4,-4},	// 50.0%
		{ 4, 4, 4, 4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4,-4}	// 25.0%
	},

	{	DLAY_CONST_INT*5  ,DLAY_CONST_INT*127,DLAY_CONST_INT*10 ,DLAY_CONST_INT*1  ,
		DLAY_CONST_INT*20 ,DLAY_CONST_INT*2  ,DLAY_CONST_INT*40 ,DLAY_CONST_INT*3  ,
		DLAY_CONST_INT*80 ,DLAY_CONST_INT*4  ,DLAY_CONST_INT*30 ,DLAY_CONST_INT*5  ,
		DLAY_CONST_INT*7  ,DLAY_CONST_INT*6  ,DLAY_CONST_INT*13 ,DLAY_CONST_INT*7  ,
		DLAY_CONST_INT*6  ,DLAY_CONST_INT*8  ,DLAY_CONST_INT*12 ,DLAY_CONST_INT*9  ,
		DLAY_CONST_INT*24 ,DLAY_CONST_INT*10 ,DLAY_CONST_INT*48 ,DLAY_CONST_INT*11 ,
		DLAY_CONST_INT*96 ,DLAY_CONST_INT*12 ,DLAY_CONST_INT*36 ,DLAY_CONST_INT*13 ,
		DLAY_CONST_INT*8  ,DLAY_CONST_INT*14 ,DLAY_CONST_INT*16 ,DLAY_CONST_INT*15
	}
};

static	void	MMC5_GenerateSquare (PMMC5sqr ChanData, s16 *Target, int Size)
{
	int x, LDuty, Vol;
	for (x = 0; x < Size; x++)
	{
		if (ChanData->freq <= 4)
			return;
		LDuty = MMC5sound_data.Duties[ChanData->duty][ChanData->CurD];
		ChanData->LCtr -= NES_INC_SIZE_INT;
		if (ChanData->LCtr < 0)
		{
			ChanData->CurD++;
			ChanData->CurD &= 0xF;
			ChanData->LCtr += (ChanData->freq + 1) << 16;
		}
		if (!ChanData->wavehold)
		{
			ChanData->Timer -= NUM_MS_FRAME_INT;
			if (ChanData->Timer < 0)
			{
				LDuty = 0;
				ChanData->Timer = 0;
			}
		}
		if (!ChanData->envelope)
		{
			Vol = ChanData->Envelope;
			ChanData->EnvCtr -= NUM_MS_FRAME_INT;
			if (ChanData->EnvCtr < 0)
			{
				ChanData->EnvCtr += (ChanData->volume+1)*QUARTER_VBLANK_INT;
				ChanData->Envelope--;
				Vol = ChanData->Envelope;
				if (ChanData->Envelope < 0)
				{
					LDuty = 0;
					if (ChanData->wavehold)
						ChanData->Envelope = 15;
					else	ChanData->Envelope = 0;
				}
			}
		}
		else	Vol = ChanData->volume;
		Target[x] += LDuty*Vol;
	}
}

void	MMC5sound_Init (void)
{
	memset(&MMC5sound,0,sizeof(TMMC5sound));
}

void	MMC5sound_Write (int Where, int What)
{
	switch (Where)
	{
	case 0x5000:	MMC5sound.Sqr0.byte0 = What;	break;
	case 0x5002:	MMC5sound.Sqr0.byte2 = What;	break;
	case 0x5003:	MMC5sound.Sqr0.byte3 = What;
			MMC5sound.Sqr0.Timer = MMC5sound_data.DLays[MMC5sound.Sqr0.length];
			MMC5sound.Sqr0.Envelope = 15;	break;
	case 0x5004:	MMC5sound.Sqr1.byte0 = What;	break;
	case 0x5006:	MMC5sound.Sqr1.byte2 = What;	break;
	case 0x5007:	MMC5sound.Sqr1.byte3 = What;
			MMC5sound.Sqr1.Timer = MMC5sound_data.DLays[MMC5sound.Sqr1.length];
			MMC5sound.Sqr1.Envelope = 15;	break;
	case 0x5010:	if (What & 1)
				MP->DbgOut("Ack! MMC5 RAW PCM is being used!");
							break;
	case 0x5011:	MP->GetWriteHandler(0x4)(0x4,0x011,What);	break;
	case 0x5015:	if (What & 0x01)
				MMC5sound.Sqr0.Enabled = 1;
			else
			{
				MMC5sound.Sqr0.Enabled = 0;
				MMC5sound.Sqr0.Timer = 0;
				MMC5sound.Sqr0.wavehold = 0;
			}
			if (What & 0x02)
				MMC5sound.Sqr1.Enabled = 1;
			else
			{
				MMC5sound.Sqr1.Enabled = 0;
				MMC5sound.Sqr1.Timer = 0;
				MMC5sound.Sqr1.wavehold = 0;
			}				break;
	}
}

void	MMC5sound_Get (s16 *Target, int Size)
{
	if (MMC5sound.Sqr0.Enabled)	MMC5_GenerateSquare(&MMC5sound.Sqr0,Target,Size);
	if (MMC5sound.Sqr1.Enabled)	MMC5_GenerateSquare(&MMC5sound.Sqr1,Target,Size);
/*	MMC5_GeneratePCM(&MMC5sound.PCM,Target,Size); */
}

int	MMC5sound_SaveMI (Ar128 MI, int x)
{
	MI[x++] = MMC5sound.Sqr0.byte0;
	MI[x++] = MMC5sound.Sqr0.byte2;
	MI[x++] = MMC5sound.Sqr0.byte3;
	MI[x++] = MMC5sound.Sqr0.Enabled;
	MI[x++] = MMC5sound.Sqr1.byte0;
	MI[x++] = MMC5sound.Sqr1.byte2;
	MI[x++] = MMC5sound.Sqr1.byte3;
	MI[x++] = MMC5sound.Sqr1.Enabled;
	return x;
}

int	MMC5sound_LoadMI (const Ar128 MI, int x)
{
	MMC5sound.Sqr0.byte0 = MI[x++];
	MMC5sound.Sqr0.byte2 = MI[x++];
	MMC5sound.Sqr0.byte3 = MI[x++];
	MMC5sound.Sqr0.Enabled = MI[x++];
	MMC5sound.Sqr1.byte0 = MI[x++];
	MMC5sound.Sqr1.byte2 = MI[x++];
	MMC5sound.Sqr1.byte3 = MI[x++];
	MMC5sound.Sqr1.Enabled = MI[x++];
	return x;
}

void	MMC5sound_Destroy (void)
{
}