#ifndef	__SND_FDS_H__
#define	__SND_FDS_H__

#define FDSClock (111860 * 2)

typedef	struct	FDSsound
{
	s64 cycles;		// Cycles per PCM sample
	s64 count;		// Cycle counter
	s64 envcount;		// Envelope cycle counter
	u32 b19shiftreg60;
	u32 b24adder66;
	u32 b24latch68;
	u32 b17latch76;
	s32 clockcount;		// Counter to divide frequency by 8.
	u8 b8shiftreg88;	// Modulation register.
	u8 amplitude[2];	// Current amplitudes.
	u8 mwave[0x20];		// Modulation waveform
	u8 cwave[0x40];		// Game-defined waveform(carrier)
	u8 SPSG[0x10];
}	TFDSsound, *PFDSsound;

void	FDSsound_Init (void);
int	FDSsound_Read (int);
void	FDSsound_Write (int,int);
void	FDSsound_Get (s16 *,int);
int	FDSsound_SaveMI (Ar128,int);
int	FDSsound_LoadMI (const Ar128,int);
void	FDSsound_Destroy (void);

#endif	/* __SND_FDS_H__ */