#include	"..\..\interface.h"
#include	"s_FDS.h"

// Sound code borrowed from FCE Ultra 0.70 by Xodnizel

static	TFDSsound	FDSsound;

static	void	DoEnv (void)
{
	int x;
	for (x = 0; x < 2; x++)
	{
		if (!(FDSsound.SPSG[x<<2]&0x80))
		{
			static int counto[2]={0,0};
			if (counto[x] <= 0)
			{
				if (FDSsound.SPSG[x << 2] & 0x40)
				{
					if (FDSsound.amplitude[x] < 0x3F)
						FDSsound.amplitude[x]++;
				}
				else
				{
					if (FDSsound.amplitude[x] > 0)
						FDSsound.amplitude[x]--;
				}
				counto[x] = (FDSsound.SPSG[x << 2] & 0x3F);
			}
			else	counto[x]--;
		}
	}
}

static	void	ClockRise (void)
{
	if(!FDSsound.clockcount)
	{
		FDSsound.b19shiftreg60 = (FDSsound.SPSG[0x2] | ((FDSsound.SPSG[0x3] & 0xF) << 8));
		FDSsound.b17latch76 += (FDSsound.SPSG[0x6] | ((FDSsound.SPSG[0x7] & 0x3) << 8));

		if (!(FDSsound.SPSG[0x7] & 0x80))
			FDSsound.b8shiftreg88 = (FDSsound.amplitude[1] * ((FDSsound.mwave[(FDSsound.b17latch76 >> 11) & 0x1F] & 7)));
		else	FDSsound.b8shiftreg88 = 0x00;
	}
	else
	{
		FDSsound.b19shiftreg60 <<= 1;
		FDSsound.b8shiftreg88 >>= 1;
	}
	FDSsound.b24adder66 = (FDSsound.b24latch68 + FDSsound.b19shiftreg60) & 0xFFFFFF;
}

static  void	ClockFall (void)
{
/*	if(!(FDSsound.SPSG[0x7] & 0x80))
	{
		if(!(FDSsound.b8shiftreg88 & 1))
			FDSsound.b24latch68 = FDSsound.b24adder66;
	}
	else //if(FDSsound.clockcount <= 5)
*/
	if(!(FDSsound.b8shiftreg88 & 1))
		FDSsound.b24latch68 = FDSsound.b24adder66;
	FDSsound.clockcount = (FDSsound.clockcount + 1) & 0x7;
}

void	FDSsound_Init (void)
{
	memset(&FDSsound,0,sizeof(FDSsound));
	FDSsound.cycles = (s64)32768 * FDSClock / 44100;
}

int	FDSsound_Read (int Where)
{
	if ((0x4040 <= Where) && (Where <= 0x407F))
		return FDSsound.cwave[Where & 0x3F];
	return 0;
}

void	FDSsound_Write (int Where, int What)
{
	if ((0x4040 <= Where) && (Where <= 0x407F))
	{
		if (FDSsound.SPSG[0x9] & 0x80)
			FDSsound.cwave[Where & 0x3F] = What & 0x3F;
	}
	else if ((0x4080 <= Where) && (Where <= 0x408F))
	{
		switch (Where & 0xF)
		{
		case 0x0: 
		case 0x4:	if (!(What & 0x80))
				{
					/*if (What & 0x40)
						FDSsound.amplitude[(Where & 0xF) >> 2] = 0;
					else	FDSsound.amplitude[(Where & 0xF) >> 2] = 0x3F;*/
				}
				else	FDSsound.amplitude[(Where & 0xF) >> 2] = What & 0x3F;	break;
		case 0x7:	FDSsound.b17latch76 = 0;
				FDSsound.SPSG[0x5] = 0;						break;
		case 0x8:	FDSsound.mwave[FDSsound.SPSG[0x5] & 0x1F] = What & 0x7;
				FDSsound.SPSG[0x5] = (FDSsound.SPSG[0x5] + 1) & 0x1F;		break;
		}
		FDSsound.SPSG[Where & 0xF] = What;
	}
}

void	FDSsound_Get (s16 *Target, int Size)
{
	int x;

	if (FDSsound.SPSG[0x9] & 0x80)
		return;
	for (x = 0; x < Size; x++)
	{
		FDSsound.count += FDSsound.cycles;
		while (FDSsound.count >= 32768)
		{
			FDSsound.count -= 32768;
			ClockRise();
			ClockFall();
		}

		FDSsound.envcount -= FDSsound.cycles;
		if (FDSsound.envcount <= 0)
		{
			FDSsound.envcount += (s64)32768 * FDSClock / 1024;
			DoEnv();
		}
		// Need to emulate applying the amplitude to the waveform a bit better...
		Target[x] += ((FDSsound.cwave[FDSsound.b24latch68 >> 18] - 0x20) * FDSsound.amplitude[0]) >> 4;
	}
}

int	FDSsound_SaveMI (Ar128 MI, int x)
{
	return x;
}

int	FDSsound_LoadMI (const Ar128 MI, int x)
{
	return x;
}

void	FDSsound_Destroy (void)
{
}